// By EVOLVED
// www.evolved-software.com

#include "settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj;
   float4x4 ViewInv;
   float4x4 ViewProjInv;

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float2 Aspect={1.0,1.0};
   float Offset=4.0;
   float2 DofMultiplier={1.0,1.0};
   float DofMinRange=100000.0;
   float COCSize=4.0;
   float4 SamplesOffset[18]={float4(2,0,0,0),
	                     float4(1,0,0,0),
	                     float4(-1,0,0,0),
	                     float4(-2,0,0,0),
	                     float4(1.5,0.875,0,0),
	                     float4(0.5,0.875,0,0),
	                     float4(-0.5,0.875,0,0),
	                     float4(-1.5,0.875,0,0),
	                     float4(1.5,-0.875,0,0),
	                     float4(0.5,-0.875,0,0),
	                     float4(-0.5,-0.875,0,0),
	                     float4(-1.5,-0.875,0,0),
	                     float4(1,1.75,0,0),
	                     float4(0,1.75,0,0),
	                     float4(-1,1.75,0,0),
	                     float4(1,-1.75,0,0),
	                     float4(0,-1.75,0,0),
	                     float4(-1,-1.75,0,0)};

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
         Texture=<DepthTexture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture AdaptedLumTexture <string Name = " ";>;
   sampler AdaptedLumSampler=sampler_state 
      {
         Texture=<AdaptedLumTexture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
      {
         float4 Pos:POSITION;
      };
   struct OutPut
      {
         float4 Pos:POSITION; 
         float4 Tex:TEXCOORD0;
         float4 Tex1:TEXCOORD1;
         float4 Tex2:TEXCOORD2;
         float4 Tex3:TEXCOORD3;
         float4 Tex4:TEXCOORD4;
         float3 ViewPos:TEXCOORD5;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
      {
         OutPut OUT;
         OUT.Pos=IN.Pos; 
         OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5);
         OUT.Tex.zw=0.0;
         OUT.Tex1.xy=OUT.Tex+float2(ViewSize.x,0.0)*Offset*Aspect*1.2;
         OUT.Tex1.zw=OUT.Tex+float2(0.0,ViewSize.y)*Offset*Aspect*1.2;
         OUT.Tex2.xy=OUT.Tex-float2(ViewSize.x,0.0)*Offset*Aspect*1.2;
	 OUT.Tex2.zw=OUT.Tex-float2(0.0,ViewSize.y)*Offset*Aspect*1.2;
         OUT.Tex3.xy=OUT.Tex+float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex3.zw=OUT.Tex-float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex4.xy=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*Offset*Aspect;
         OUT.Tex4.zw=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*Offset*Aspect;
         OUT.ViewPos=mul(float4(IN.Pos.xy,0,1),ViewProjInv);
         return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
      {
	 float Depth=tex2Dlod(DepthSampler,IN.Tex).w;
	 float3 FrameRender=tex2Dlod(RenderSampler,IN.Tex);
	 #if DOF == 1
	  float2 AutoFocus=min(tex1Dlod(AdaptedLumSampler,0.0).yy,DofMinRange)*DofMultiplier;
	  float Focus=saturate((Depth-AutoFocus.x)/AutoFocus.y);
          float4 COCRad=float4(ViewSize*COCSize*Focus,0.0,0.0);
          float4 DofCOC=float4(FrameRender,1.0);
          for (int i = 0; i < 18; i++) {
           float4 TexTap=IN.Tex+SamplesOffset[i]*COCRad;
           float3 FrameTap=tex2Dlod(RenderSampler,TexTap);
           float FocusTap=saturate((tex2Dlod(DepthSampler,TexTap).w-AutoFocus.x)/AutoFocus.y);
           DofCOC +=float4(FrameTap*FocusTap,FocusTap);
          }
          FrameRender=DofCOC.xyz/DofCOC.w;
         #else
          float Focus=0.0;
         #endif
         float3 DownFilter=tex2Dlod(RenderSampler,IN.Tex).xyz*0.25
                          +tex2Dlod(RenderSampler,IN.Tex1.xyyy).xyz*0.125
                          +tex2Dlod(RenderSampler,IN.Tex1.zwww).xyz*0.125
                          +tex2Dlod(RenderSampler,IN.Tex2.xyyy).xyz*0.125
                          +tex2Dlod(RenderSampler,IN.Tex2.zwww).xyz*0.125
                          +tex2Dlod(RenderSampler,IN.Tex3.xyyy).xyz*0.0625
                          +tex2Dlod(RenderSampler,IN.Tex3.zwww).xyz*0.0625
                          +tex2Dlod(RenderSampler,IN.Tex4.xyyy).xyz*0.0625
                          +tex2Dlod(RenderSampler,IN.Tex4.zwww).xyz*0.0625;
         if(Depth<64000.0) {
          float3 WorldPos=ViewInv[3].xyz+normalize(IN.ViewPos)*(Depth*2.0);
          Depth=mul(float4(WorldPos,1.0),ViewProj).z*0.5; 
         }
         return float4(lerp(DownFilter,FrameRender,saturate(Focus*16)),Depth);
      }

//--------------
// techniques   
//--------------
   technique Downfilter
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS();
         zwriteenable=false;
         zenable=false;
         ZFunc=always;
      }
      }
